/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.api.common.skill.ISkillHierarchy;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.skills.core.SkillCategory;
import dev.toma.gunsrpg.common.skills.core.SkillHierarchy;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.lang.reflect.Type;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public class SkillHierarchyAdapter
implements JsonDeserializer<ISkillHierarchy<?>> {
    public ISkillHierarchy<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(json);
        String categoryKey = JSONUtils.func_151200_h((JsonObject)object, (String)"category");
        SkillCategory category = SkillHierarchyAdapter.deserializeCategory(categoryKey);
        SkillType<?> parent = SkillHierarchyAdapter.deserializeParent(object);
        SkillType<?> override = SkillHierarchyAdapter.deserializeOverride(object);
        SkillType<?>[] children = SkillHierarchyAdapter.deserializeChildren(object);
        SkillType<?>[] extensions = SkillHierarchyAdapter.deserializeExtensions(object);
        return new SkillHierarchy(category, parent, override, children, extensions);
    }

    private static SkillType<?> deserializeOverride(JsonObject object) throws JsonParseException {
        if (!object.has("override")) {
            return null;
        }
        JsonElement overrideJson = object.get("override");
        if (overrideJson.isJsonNull()) {
            return null;
        }
        return SkillHierarchyAdapter.parseSkillByKey(overrideJson.getAsString());
    }

    private static SkillType<?>[] deserializeExtensions(JsonObject object) throws JsonParseException {
        if (!object.has("extensions")) {
            return null;
        }
        JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"extensions");
        SkillType[] ext = new SkillType[array.size()];
        int index = 0;
        for (JsonElement element : array) {
            ext[index++] = SkillHierarchyAdapter.parseSkillByKey(element.getAsString());
        }
        return ext;
    }

    private static SkillType<?>[] deserializeChildren(JsonObject object) throws JsonParseException {
        if (object.has("children")) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"children");
            SkillType[] children = new SkillType[array.size()];
            int index = 0;
            for (JsonElement element : array) {
                children[index++] = SkillHierarchyAdapter.parseSkillByKey(element.getAsString());
            }
            return children;
        }
        return null;
    }

    private static SkillType<?> deserializeParent(JsonObject object) throws JsonParseException {
        return SkillHierarchyAdapter.parseSkillFromObject(object, "parent");
    }

    private static SkillCategory deserializeCategory(String categoryKey) throws JsonParseException {
        try {
            return SkillCategory.get(categoryKey);
        }
        catch (Exception e) {
            throw new JsonSyntaxException("Invalid skill category key: " + categoryKey);
        }
    }

    private static SkillType<?> parseSkillFromObject(JsonObject object, String key) throws JsonParseException {
        if (object.has(key)) {
            JsonElement element = object.get(key);
            if (element.isJsonNull()) {
                return null;
            }
            return SkillHierarchyAdapter.parseSkillByKey(element.getAsString());
        }
        return null;
    }

    private static SkillType<?> parseSkillByKey(String key) throws JsonParseException {
        IForgeRegistry<SkillType<?>> registry = ModRegistries.SKILLS;
        ResourceLocation location = new ResourceLocation(key);
        SkillType type = (SkillType)registry.getValue(location);
        if (type == null) {
            throw new JsonSyntaxException("Unknown skill: " + key);
        }
        return type;
    }

    private static JsonObject getChildObject(JsonObject object) {
        if (object.has("children")) {
            JsonElement value = object.get("children");
            if (value.isJsonNull()) {
                return null;
            }
            return JsonHelper.asJsonObject(value);
        }
        return null;
    }
}

